-- ANMERKUNG: siehe "Y TWawi.Views.Auftrag.sql"

--
CREATE OR REPLACE FUNCTION TSystem.views__Wawi_Ausgangsrechnung__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS TWawi.rechnung_posext;
        DROP VIEW IF EXISTS TWawi.rechnung_belegext;
    --
    
    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    --
    -- Da die Grundtabelle belzeil_grund nicht wirklich für ein UPDATE geeignet ist (wird nicht in die relevanten abgeleiteten Tabellen geschrieben)
    -- und die Umsetzung der 2 abgeleiteten Tabellen belzeil_auftg_lif und belzeil_frei unklar ist, erstmal keine Updatable-Views.
    --
    CREATE OR REPLACE VIEW TWawi.rechnung_belegext AS
      SELECT
        belkopf.dbrid                                                AS dbrid,
        be_bnr                                                       AS d_dokunr,
        
        be_abprozent                                                 AS d_aproz, --An/Abschlagsrechnung-Prozent
        
        be_prof                                                      AS d_typ,
        be_def                                                       AS d_def,
        be_bdat                                                      AS d_insert_date,
        
        COALESCE(be_titel, lang_belart(be_txba))                     AS d_titel,
        COALESCE(be_bem1_rtf, be_bem1)                               AS d_kopftext,
        COALESCE(be_bem2_rtf, be_bem2)                               AS d_fusstext,
        be_bem1                                                      AS d_kopftext_txt,
        be_bem2                                                      AS d_fusstext_txt,
        
        be_rkrz                                                      AS d_adkrz,
        adk_ad_krz::VARCHAR(30)                                      AS d_ad_krz, --richtiges Adresskürzel (Liefer/Rechnungs-Unteradresskürzel)
        
        be_apkrzl                                                    AS d_apext,
        be_ap                                                        AS d_apextname,
        
        be_apint                                                     AS d_apint,
        nameAufloesen(be_apint)                                      AS d_apintname,
        
        ad_ustidnr                                                   AS ustidnr,
        
        be_zak                                                       AS d_zahlungbis,
        be_skv                                                       AS d_skv,
        be_sks                                                       AS d_sks,
        be_bdat+be_zak                                               AS d_datum_soll,
        be_buchdat                                                   AS d_datum_fibu_buchung, -- Datum des Exports in die Buchhaltungsschnittstelle
        
        be_zahl_erledigt                                             AS d_zahlung_done,
        ((be_bdat+be_zak ) < current_Date) AND NOT be_zahl_erledigt  AS d_zahlung_done_CimRed,
        
        be_gesamt_net                                                AS d_wert_netto,
        be_gesamt_steu                                               AS d_wert_brutto,
        
        a1_knr                                                       AS d_adkrz_nr,
        
        COALESCE(be_waco, TSystem.Settings__Get('BASIS_W'))::VARCHAR(10)        AS d_we
      FROM belkopf
        LEFT JOIN adressen_view ON ad_krz = be_rkrz --wegen Debitorendaten
        LEFT JOIN adk1          ON a1_krz = adk_ad_krz --debitorendaten zur Adresse
        LEFT JOIN adkap         ON adk_ad_krz = ap_ad_krz AND ap_krzl = be_apkrzl AND ap_krzl IS NOT NULL
      ORDER BY
        be_bdat DESC, be_bnr DESC
    ;
    
    -- Erweiterter Anzeige-View => Nur lesbar.
    CREATE OR REPLACE VIEW TWawi.rechnung_posext AS
      SELECT
      -- Identifikatoren
        pos.dbrid            AS dbrid                     ,--
        bz_id                AS p_id                      ,-- ID der Pos.
        bz_be_bnr            AS p_dokunr                  ,-- Referenz auf das zug. Dokument
        be_prof              AS p_code                    ,-- Code / Klassifikation / Belegtyp
        bz_be_bnr            AS p_nummer                  ,-- Belegnummer
        bz_pos               AS p_pos                     ,-- Positionsnummer
        bz_hwpos             AS p_parent                  ,-- Übergeordnete Position (Strukt. Belege)
        'belzeil_grund'::VARCHAR   AS p_table             ,-- Tabelle aus der die Position stammt, hier die Grundtabelle, Felder aus belzeil_auftg_lif etc. fehlen also.
      -- Artikeldaten
        bz_aknr              AS p_aknr                    ,-- Artikelnummer
        COALESCE(ag_aknr_idx, ak_idx) AS p_aknr_idx       ,-- Artikelindex
        COALESCE(bz_akbz, ak_bez)     AS p_akbez          ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        ag_aknr_referenz     AS p_aknr_referenz           ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        bz_fakt              AS p_menge                   ,-- Menge in Positions-ME
        bz_mce               AS p_me                      ,-- artmgc.m_id der Positions-ME
        ak_los               AS p_los                     ,-- Losgröße für Artikel
        bz_fakt_uf1          AS p_menge_gme               ,-- Menge in GME
        NULL::NUMERIC        AS p_mengeb_gme              ,-- Menge bestellt in GME
        NULL::NUMERIC        AS p_mengel_gme              ,-- Menge geliefert in GME
        NULL::NUMERIC        AS p_mengef_gme              ,-- Menge fakturiert in GME
        bz_fakt              AS p_mengeo                  ,-- Noch zu bestellende Menge
        bz_fakt_uf1          AS p_mengeo_gme              ,-- Noch zu bestellende Menge in GME
        ak_norm              AS p_norm                    ,-- Artikelnorm
        bz_ks                AS p_ks                      ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                      ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                      ,-- ME-Code der Positions-ME
        MEData.p_gmec                                     ,-- ME-Code der Grund-ME
        MEData.p_meuf                                     ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                    ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                   ,-- ISO-Code der Grund-ME
      -- Preisdaten
        bz_preis             AS p_preis                   ,-- Preis pro ME (enthält Preiseinheit)
        bz_preiseinheit      AS p_preiseinheit            ,-- Menge auf die sich p_preis bezieht
        bz_vkp               AS p_preis_me                ,-- Preis pro ME        
        bz_vkp_basis_w       AS p_preis_gwaer             ,-- Preis pro ME in Grundwährung
        bz_vkp_uf1           AS p_preis_gme               ,-- Preis pro GME
        bz_vkp_uf1_basis_w   AS p_preis_gme_gwaer         ,-- Preis pro GME in Grundwährung
        be_waco              AS p_waer                    ,-- Pos. Währungseinheit
        be_umr               AS p_kurs                    ,-- Pos. Kurs zur Basiswährung
        bz_steucode          AS p_scode                   ,-- Steuercode
        bz_steuproz          AS p_sproz                   ,-- Steuerprozentsatz
        bz_gesrab            AS p_rabatt                  ,-- Rabattsatz (0...100)
        bz_canrabatt         AS p_canRabatt               ,-- Kennzeichen Rabattfähig
        steu_txt             AS p_sbez                    ,-- Steuerbezeichnung
      -- Positionswerte
        bz_tot               AS p_wert_netto              ,-- Positionswert, exkl. Steuern, inkl. AbZuschläge
        bz_tot_steu          AS p_wert_brutto             ,-- Positionswert, inkl. Steuern, inkl. AbZuschläge
        bz_tot_basis_w       AS p_wert_netto_gwaer        ,-- Positionswert, exkl. Steuern, in Grundwährung, inkl. AbZuschläge
        bz_tot_steu_basis_w  AS p_wert_brutto_gwaer       ,-- Positionswert, inkl. Steuern, in Grundwährung, inkl. AbZuschläge
      -- Adressdaten
        adk_ad_krz           AS p_adkrz                   ,-- Adresskürzel (Kunde o. Lieferant)
        be_liefkrz           AS p_adkrzl                  ,-- Adresskürzel Lieferadresse
        be_rkrz              AS p_adkrzf                  ,-- Adresskürzel Rechnungsadresse
        be_apkrzl            AS p_apext                   ,-- Kürzel Ansprechpartner extern
        be_ap                AS p_apExtName               ,-- Voller Name Ansprechpartner extern
        be_apint                AS p_apInt                ,-- Kürzel Ansprechpartner intern
        nameAufloesen(be_apint) AS p_apintname            ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        pos.insert_date      AS p_datum_eingang           ,-- Eingangsdatum
        be_bdat              AS p_datum_erfasst           ,-- Erfassdatum
        be_bdat + COALESCE(be_zak, 0) AS p_datum_soll     ,-- Wunschdatum
        be_bdat + COALESCE(be_zak, 0) AS p_datum_ist      ,-- Bestätigtes Datum
        be_bdat + COALESCE(be_zak, 0) AS p_datum_istsoll  ,-- Eigentlicher Termin
        be_buchdat           AS p_datum_fibu_buchung      ,-- Datum des Exports in die Buchhaltungsschnittstelle
        NULL::DATE           AS p_datum_storniert         ,-- Datum an dem die Pos. Storniert wurde
        be_def               AS p_definitiv               ,-- Kennzeichen Pos. Definitiv
        bz_buchdone          AS p_done                    ,-- Kennzeichen Pos. Erledigt
        false                AS p_storniert               ,-- Kennzeichen Pos. Storniert
        NULL::BOOLEAN        AS p_IsBedarf                ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung         AS p_IsFertigung             ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        true                 AS p_IsUmsatz                ,-- Kennzeichen umsatzwirksame Position
        NULL::VARCHAR        AS p_status                  ,-- Allg. Status1
        NULL::VARCHAR        AS p_status1                 ,-- Allg. Status2
        NULL::VARCHAR        AS p_status2                 ,-- Allg. Status3
      -- Referenzen / Struktur
        ag_rahmen_ag_id      AS p_rahmen_id               ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        'auftg'::VARCHAR     AS p_vorgaenger_table        ,--
        ag_id                AS p_vorgaenger_id           ,--
        bz_bda               AS p_refnummer               ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        NULL::INTEGER        AS p_refpos                  ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        bz_an_nr             AS p_an_nr                   ,-- Projektnummer
        ag_vtp_id            AS p_vtp_id                  ,-- ID der zugehörigen Vertragsposition
        -- bz_ab_ix             AS p_ab_ix                   ,-- Zugehörige ABK -- Braucht keiner im Beleg, wird evtl gedroppt (Aufteilungsbuchungen) DS:2019-08-19
        ag_q_nr              AS p_q_nr                    ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        bz_zeko              AS p_konto                   ,-- Kontierung
        bz_zubez             AS p_txt_ext                 ,-- Positionstext extern
        bz_zubez_rtf         AS p_txt_ext_rtf             ,--
        NULL::TEXT           AS p_txt_int                 ,-- Positionstext intern
        NULL::TEXT           AS p_txt_int_rtf              --
      FROM belzeil_grund AS pos
        JOIN belkopf                ON be_bnr  = bz_be_bnr
        -- LEFT aufgrund mgl. freier Eingabe vom Artikel
        LEFT JOIN art               ON ak_nr   = bz_aknr
        JOIN adressen_view          ON ad_krz  = be_rkrz
        LEFT JOIN auftg             ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos
        LEFT JOIN steutxt           ON steu_z  = bz_steucode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        -- hier inkl. Sonderfall der freien Eingabe von ME und Artikel bei freier Rechnungsposition
        LEFT JOIN LATERAL (
            SELECT
              m2.m_id                               AS p_gme,   -- GME artikelspez. ID
              COALESCE(m1.m_mgcode, mfrei.me_cod)   AS p_mec,   -- ME-Code für auftragsbezogene bzw. freie Rechnungspos.
              m2.m_mgcode                           AS p_gmec,  -- GME-Code
              COALESCE(m1.m_uf, 1)                  AS p_meuf,  -- ME-UF mit Fallback auf 1 für freie Rechnungspos.
              
              -- ME-ISO-Bez.
              COALESCE(
                  -- auftragsbezogene Rechnungspos.
                  lang_artmgc_id_iso(m1.m_id),
                  -- Fallback auf freie Rechnungspos. (wenn ME-String in Stammdaten vorhanden)
                  lang_mgcode_iso(mfrei.me_cod),
                  -- Fallback auf komplett freie Eingabe bei freie Rechnungspos.
                  bz_mcbez
              )                                     AS p_meiso,
              
              lang_artmgc_id_iso(m2.m_id)           AS p_gmeiso -- GME-ISO-Bez.
            
            -- Ausgangspunkt 1 Zeile, Rest ggf. alles NULL
            FROM (SELECT true) AS one_row
              
              -- LEFT aufgrund mgl. freier Eingabe von ME
              LEFT JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = pos.bz_mce)
              
              -- LEFT aufgrund mgl. freier Eingabe vom Artikel
              LEFT JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
              
              -- Für freie Rechnungspos. wird nur ME-String eingetragen, #13462
              -- Daher wird versucht, den ME-Code anhand freier, sprachbezogener Eingabe (DE, EN usw.) zu ermitteln.
              LEFT JOIN LATERAL (
                  SELECT me_cod
                  FROM mgcodelang
                    JOIN mgcode ON me_cod = mel_me_cod
                  
                  -- freie sprachbezogene Eingabe der ME bei freier Rechnungspos. Ggf. per F2 aus Stammdaten.
                  WHERE COALESCE(mel_txt, me_bez, me_iso) = pos.bz_mcbez
                  ORDER BY me_cod
                  LIMIT 1 -- sicherheitshalber, falls Widersprüche mit String
              ) AS mfrei
                -- Nur wenn kein MCE aber freie Eingabe vorhanden ist.
                ON pos.bz_mce IS NULL AND pos.bz_mcbez IS NOT NULL
                
        ) AS MEData
          -- Infos zur Mengenumrechnung nur, wenn Artikel oder freie ME-Eingabe vorhanden ist.
          ON (ak_nr IS NOT NULL OR pos.bz_mcbez IS NOT NULL)
    ;
    
  END $$ LANGUAGE plpgsql;
--

-- SELECT TSystem.views__Wawi_Ausgangsrechnung__recreate();